// ShowMobileIPCanvas.java
// Olof 22 jan
// Jonas 24 jan
// Jonas 28 jan
// Both 29 jan  New scenarios
// Jonas 30 jan JAVA Event 1.1

import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import Globals;
import Agent;
import MobileHost;

public class ShowMobileIPCanvas extends Canvas {
  //Package P;
  GridBagFrame frame;
  Dimension minSize;
  RegThread t;
  NotifyThread t2[] = new NotifyThread[3];
  IncludThread t3;
  SendLetterThread t4; 
  SendLetterViaHAThread t5;
  SendLetterTunnelThread t6;
  UpdateFAThread t7;
  WarningThread t8;
  int nbrOfNotifyThreads;

  public String regText1, regText3;
  public String regText2, sendText;
  public String inclText1, inclText2, inclText4, inclText3, inclText5;
  public String regText4;
  public String deregText1;
  public String deregText2, exclText;
  public String tunnelText1, tunnelText2, tunnelText3, tunnelText4; 
  public String viaHAText1, viaHAText2;
  public String updateText;

  // Constructor
  public ShowMobileIPCanvas(int width, int height, 
			    GridBagFrame father) {
   
    this.frame = father;
    minSize = new Dimension(width,height);
    this.addMouseListener(new CanvasMouseAdapter(this)); 
    this.addMouseMotionListener(new CanvasMouseMotionAdapter(this)); 
  }
    
  public Dimension getPreferredSize() {
    return getMinimumSize();
  }
  
  public Dimension getMinimumSize() {
    return minSize;
  }  

  public void paint(Graphics g) {
    for(int i=0; i <= Globals.nbrOfFA; i++) {
      Globals.FA[i].drawAgent(g);
    };
    Globals.MH.drawAgent(g, false);
  }

  public int distance(Agent ag) {
    int dx, dy;
    dx = (Globals.MH.x-ag.x);
    dy = (Globals.MH.y-ag.y);
    return (int) Math.sqrt(dx*dx+dy*dy)*2;
  }

  public Agent findConnection() {
    int shortest;
    Agent ag;
    shortest = java.lang.Integer.MAX_VALUE;
    ag = Globals.FA[0];
    for(int i=0; i <= Globals.nbrOfFA; i++) {
      if ((distance(Globals.FA[i]) < shortest) && 
	  distance(Globals.FA[i]) < Globals.FA[i].range){
        shortest = distance(Globals.FA[i]);
        ag = Globals.FA[i];
      }
    }
    if (distance(ag) < ag.range) return ag;
    else return null;
  }

  public Agent findClosest() {
    int shortest;
    Agent ag;
    shortest = java.lang.Integer.MAX_VALUE;
    ag = null;
    for(int i=0; i <= Globals.nbrOfFA; i++) {
      if (distance(Globals.FA[i]) < shortest) {
        shortest = distance(Globals.FA[i]);
        ag = Globals.FA[i];
      }
    }
    return ag;
  }
  
  // Deregistration of MH, method used in mouseDrag()
  public void deregistrationMH() { 
    
    // deregText1 = new String("-  MH leaves "
    //                   + Globals.MH.connected.name+"\n"); 
    deregText2 = new String("-  MH loses "
			+ "contact and deregisters with " 
                        + Globals.MH.connected.name +"\n");
    
    frame.textArea1.appendHiLit("\nDEREGISTRATION\n");
    frame.textArea1.appendHiLit(deregText2);     
    int i = 0;
    if (Globals.MH.connected != Globals.FA[0])
      frame.textArea1.appendHiLit("-  "+Globals.MH.connected.name
       		       + " believes that MH returns to HA\n");
    else
      frame.textArea1.appendHiLit(
		    "-  HA does not know the location of MH\n");
    Agent tempAgent;
    Agent tempAgent2 = Globals.MH.connected;
    if (!Globals.doInc) 
      tempAgent = Globals.MH.connected;
    else 
      tempAgent = Globals.newAgent;
    Globals.MH.connected = null;
    if (tempAgent == Globals.FA[0])
      tempAgent.believeMH = null;
    else
      tempAgent.believeMH = Globals.FA[0];

    while (tempAgent != Globals.FA[i])
      i++;
    if (Globals.dialogExist[i]) Globals.Dialogs[i].reDraw2();
    nbrOfNotifyThreads = 0;
    if (tempAgent2 != Globals.FA[0]) {
      frame.textArea1.appendHiLit("-  " + tempAgent.name
	       	+ " notifys other concerned agents that MH is no longer at "
	       	+ tempAgent.name + "\n");
      notifyAgent(Globals.FA[0], tempAgent2);
      for (int nbr = 1; nbr < Globals.nbrOfFA+1; nbr++) {
	if (Globals.MH.needUpdate[nbr]) {
	  notifyAgent(Globals.FA[nbr], tempAgent);
	  Globals.MH.needUpdate[nbr] = false;
	}
      }
    }
    else
      if (Globals.doInc){
	Globals.doInc = false;
	Globals.MH.connected = Globals.newAgent;
	Globals.MH.connected.believeMH = Globals.newAgent;
	includationMH();
	paint(this.getGraphics());
      }
    //frame.textArea1.append("\n");
  }

  public void notifyAgent(Agent Ag, Agent fromAgent) {
    t2[nbrOfNotifyThreads] = new NotifyThread();      
    t2[nbrOfNotifyThreads].start(fromAgent, Ag, this);
    nbrOfNotifyThreads++;
    Globals.whichThread = 2;
  }
    
  // Registration of MH, method used in mouseDrag()
  public void registrationMH() {
    regText1 = new String(
           "- MH enters network area of " + Globals.MH.connected.name + "\n"
	   +"- "+ Globals.MH.connected.name + " notices a new MH in its network"
	   + "\n");
    regText2 = new String("- " + Globals.MH.connected.name 
	   + " sends a message to HA with a request to register MH at " 
           + Globals.MH.connected.name + "\n");
    regText3 = new String(
	   "- HA agrees and registers the location of MH at " 
           + Globals.MH.connected.name + "\n");
    regText4 = new String("- The registration of MH at " 
           + Globals.MH.connected.name + " is completed\n");

    frame.textArea1.appendHiLit("\nREGISTRATION\n");
    
    if (Globals.MH.connected != Globals.FA[0]) {
      t = new RegThread();      
      t.start(Globals.MH.connected.x, Globals.MH.connected.y, 
	      Globals.FA[0].x, Globals.FA[0].y, this);
      Globals.whichThread = 1;
           
    }
    else {
      frame.textArea1.appendHiLit(regText1 + regText4);
      Globals.FA[0].believeMH = Globals.MH.connected;
      if (Globals.dialogExist[0])
	Globals.Dialogs[0].reDraw2();
    }
  }

 // Excludation of MH, method used in checkConnection() in AgentDialog
  public void excludationMH() {
    frame.textArea1.appendHiLit("\nEXCLUDATION\n");
    exclText = "-  "+ Globals.MH.connected.name
             + "'s network area does not cover MH anymore\n"
             + "-  MH loses contact and is considered deregistered with " 
             + Globals.MH.connected.name +"\n";
    frame.textArea1.appendHiLit(exclText);
    nbrOfNotifyThreads = 0;
    int i = 0;
    Agent tempAgent = Globals.MH.connected;
    Globals.MH.connected = null;
    tempAgent.believeMH = null;
    while (tempAgent != Globals.FA[i])
      i++;
    if (Globals.dialogExist[i]) Globals.Dialogs[i].reDraw2();
    
    if (tempAgent != Globals.FA[0]) {
      frame.textArea1.appendHiLit("-  " + tempAgent.name
		 + " notifys other concerned agents that MH is no longer at "
                 + tempAgent.name + "\n");
      notifyAgent(Globals.FA[0], tempAgent);
      for (int nbr = 1; nbr < Globals.nbrOfFA+1; nbr++) {
	if (Globals.MH.needUpdate[nbr]) {
	  notifyAgent(Globals.FA[nbr], tempAgent);
	  Globals.MH.needUpdate[nbr] = false;
	}
      }
    }
    else {
      //frame.textArea1.append("\n");
      if (Globals.doReg) {
	Globals.doReg = false;
	Globals.MH.connected = Globals.newAgent;
	registrationMH();
      }
    }
  }

  
  // Includation of MH, method used in checkConnection()
  public void includationMH() {
    // int nbr;
    frame.textArea1.appendHiLit("\nINCLUDATION\n");
    inclText1 = new String(
           "- " + Globals.MH.connected.name + "'s network area now covers MH\n"
	   +"- "+ Globals.MH.connected.name + " notices a new MH in its network"
	   + "\n");
    inclText2 = new String("- " + Globals.MH.connected.name 
	   + " sends a message to HA with a request to register MH at " 
           + Globals.MH.connected.name + "\n");
    inclText3 = new String(
	   "- HA agrees and registers the location of MH at " 
           + Globals.MH.connected.name + "\n");
    if (Globals.MH.connected == Globals.FA[0])
       inclText4 = "";
    else
      inclText4 = "- HA sends " + Globals.MH.connected.name 
           + " an acknowledgement\n";
    inclText5 = new String("- The registration of MH at " 
           + Globals.MH.connected.name + " is completed\n");

    
    if (Globals.MH.connected != Globals.FA[0]) {
      // father.textArea1.appendHiLit(inclText1 + inclText2);
     
      t3 = new IncludThread();
      t3.start(Globals.MH.connected.x, Globals.MH.connected.y, 
              Globals.FA[0].x, Globals.FA[0].y, this);
      Globals.whichThread = 3;
    }
    else
      frame.textArea1.appendHiLit(inclText1 + inclText4);
  }  

  public void sendLetter(Agent sender, Agent start) {
    sendText = "-  Data from " + sender.name + " has arrived at MH\n";
    t4 = new SendLetterThread();
    t4.start(start, 
	     Globals.MH.x, Globals.MH.y, this, sendText);
    Globals.whichThread = 4;
  }

  public void warningLetter(Agent receiver) {
    t8 = new WarningThread();
    t8.start(receiver, this);
    Globals.whichThread = 8;
  }

  public void sendLetterViaHA(Agent sender) {
    viaHAText1 = "-  " + sender.name + " believes that MH is at HA\n";
    viaHAText2 = "-  HA gets data devoted for MH\n";
    //viaHAText3
    t5 = new SendLetterViaHAThread();
    t5.start(sender, this);
    Globals.whichThread = 5;
  }

  public void updateFA(Agent sender) {
    updateText = "- HA informs " + sender.name 
                 + " that future data should be sent directly to "
                 + Globals.MH.connected.name + "\n";
    t7 = new UpdateFAThread();
    t7.start(sender, this, updateText);
    Globals.whichThread = 7;
  }

  public void sendLetterTunnel(Agent sender) {
    tunnelText1 = "-  " + sender.name + " tunnels data to " 
                   + Globals.MH.connected.name + "\n";
    tunnelText2 = "-  Data for MH is now encapsulated and sent to "
                   + Globals.MH.connected.name + "\n"; 
    tunnelText3 = "-  The encapsulated data has arrived at "
                   + Globals.MH.connected.name +"\n";
    tunnelText4 = "-  The data is decapsulated and will be sent to MH\n";
    t6 = new SendLetterTunnelThread();
    t6.start(sender, this);
    Globals.whichThread = 6;
  }



}





